/* apps/x509AT.c */

#include <time.h>

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef OPENSSL_NO_STDIO
#define APPS_WIN16
#endif
#include "apps.h"
#include <openssl/bio.h>
#include <openssl/asn1.h>
#include <openssl/err.h>
#include <openssl/bn.h>
#include <openssl/evp.h>
#include <openssl/x509.h>
#include <openssl/x509AT.h>
#include <openssl/x509v3.h>
#include <openssl/objects.h>
#include <openssl/pem.h>

#undef PROG
#define PROG x509AT_main

#define SECTION		"x509AT"
#define PROMPT		"prompt"
#define DISTINGUISHED_NAME	"distinguished_name"
#define ATTRIBUTES	"attributes"

#undef POSTFIX
#define	POSTFIX	".srl"
#define DEF_DAYS	30

static char *x509_usage[]={
"usage: x509AT args\n",
" -inform arg     - input format - default PEM (one of DER, or PEM)\n",    //OK
" -outform arg    - output format - default PEM (one of DER, or PEM)\n",   //OK
" -keyform arg    - private key format - default PEM\n",				//OK     (CREACION CERT- Autofirmados)
" -AAform arg     - CA format - default PEM\n",							//OK     (CREACION CERT)
" -AAkeyform arg  - CA key format - default PEM\n",						//OK     (CREACION CERT)
" -in arg         - input file - default stdin\n",						//OK
" -out arg        - output file - default stdout\n",					//OK
" -passin arg     - private key password source\n",						//OK    (CREACION CERT)
" -Attribute file - set the attributes file - default 'attributes.att'\n", //OK    (CREACION CERT)
" -serial         - print serial number value\n",						//OK
" -hash           - print hash value\n",								//NO FUNCIONA ??
" -holder         - print holder information\n",						//OK  -- DN Funciona bien, mirar mas
" -issuer         - print issuer information\n",						//OK  -- DN Funciona bien, mirar mas
" -attributes     - print attributes information\n",					//OK  -- Mirar mas pruebas
" -startdate      - notBefore field\n",									//OK  
" -enddate        - notAfter field\n",									//OK  
" -purpose        - print out certificate purposes\n",					//OK
" -dates          - both Before and After dates\n",						//OK  
" -fingerprint    - print the certificate fingerprint\n",				//OK
" -alias          - output certificate alias\n",						//OK   
" -noout          - no certificate output\n",							//OK
//" -clrtrust       - clear all trusted purposes\n",						
//" -clrreject      - clear all rejected purposes\n",						
//" -addtrust arg   - trust certificate for a given purpose\n",			//OK
//" -addreject arg  - reject certificate for a given purpose\n",			//OK
" -setalias arg   - set certificate alias\n",							//OK
" -days arg       - How long till expiry of a signed certificate - def 30 days\n",  //??? Parece que no funciona
" -checkend arg   - check whether the cert expires in the next arg seconds\n",		//Ok --Mirar si funciona bien
"                   exit 1 if so, 0 if not\n",
" -User arg       - set the User certificate, must be PEM format.\n",				//OK (CREACION CERT)
" -AA arg         - set the AA certificate, must be PEM format.\n",					//OK (CREACION CERT)
" -AAkey arg      - set the AA key, must be PEM format\n",							//OK (CREACION CERT)
"                   missing, it is assumed to be in the AA file.\n",
" -AAcreateserial - create serial number file if it does not exist\n",				//OK (CREACION CERT)
" -AAserial arg   - serial file\n",													//OK (CREACION CERT)
" -set_serial     - serial number to use\n",										//OK (CREACION CERT)
" -config file    - request template file.\n",										//Todo 
" -text           - print the certificate in text form\n",							//OK 
" -md2/-md5/-sha1/-mdc2 - digest to use\n",											//OK	
" -extfile        - configuration file with X509V3 extensions to add\n",			//ToDo
" -extensions     - section from config file with X509V3 extensions to add\n",		//ToDo
" -clrext         - delete extensions before signing and input certificate\n",		//ToDo
" -HolderT type    - 0 entityName; 1 baseCertificateID; 2 objectDigestInfo PUBLICKEYCERT\n",		//ToDo
#ifndef OPENSSL_NO_ENGINE
" -engine e       - use engine e, possibly a hardware device.\n",
#endif
NULL
};

static STACK_OF(X509AT_ATTRIBUTE) * readAttributes(char *file);
static int MS_CALLBACK callb(int ok, X509_STORE_CTX *ctx);
static int x509_certify (X509_STORE *ctx,char *CAfile,const EVP_MD *digest,
			 X509AT *x,X509 *xca,EVP_PKEY *pkey,char *serial,
			 int create,int days, int clrext, CONF *conf, char *section,ASN1_INTEGER *sno,X509 *xuser,char *attributein);
static int purpose_print(BIO *bio, X509AT *cert, X509_PURPOSE *pt);
static int reqfile=0;
static X509AT *load_ATcert(BIO *err, const char *file, int format,
							const char *pass, ENGINE *e, const char *cert_descrip);

/* INHERIT REQ */
static CONF *req_conf=NULL;
static int batch=0;
static char *holdert=NULL;

int MAIN(int, char **);

int MAIN(int argc, char **argv)
	{
	ENGINE *e = NULL;
	int ret=1;
	X509 *x=NULL,*xca=NULL,*xuser=NULL;
	ASN1_OBJECT *objtmp;
	EVP_PKEY *Upkey=NULL,*CApkey=NULL;
	ASN1_INTEGER *sno = NULL;
	int i,num,badops=0;
	BIO *out=NULL;
	BIO *STDout=NULL;
	STACK_OF(ASN1_OBJECT) *trust = NULL, *reject = NULL;
	int informat,outformat,keyformat,CAformat,CAkeyformat;
	char *infile=NULL,*outfile=NULL,*keyfile=NULL,*CAfile=NULL,*template=NULL,*USERfile=NULL;
	char *CAkeyfile=NULL,*CAserial=NULL;
	char *alias=NULL;
	int text=0,serial=0,hash=0,holder=0,issuer=0,startdate=0,enddate=0,attributes=0;
	int next_serial=0;
	int noout=0,CA_flag=0,USER_flag=0,CA_createserial=0;//,email=0,sign_flag=0;
	int /*trustout=0,*/clrtrust=0,clrreject=0,aliasout=0,clrext=0;
	int x509req=0,days=DEF_DAYS;
	int pprint = 0;
	char **pp;
	X509_STORE *ctx=NULL;
	X509_REQ *rq=NULL;
	int fingerprint=0;
	const EVP_MD *md_alg,*digest=EVP_md5();
	CONF *extconf = NULL;
	char *extsect = NULL, *extfile = NULL, *passin = NULL, *passargin = NULL, *attributein=NULL;
	int need_rand = 0;
	int checkend=0,checkoffset=0;
	unsigned long nmflag = 0, certflag = 0;
#ifndef OPENSSL_NO_ENGINE
	char *engine=NULL;
#endif
	
	
	X509AT *xAT=NULL; //defino una vble para guardar certificado 
	
	req_conf = NULL;	//vble para config
	apps_startup();

	if (bio_err == NULL)
		bio_err=BIO_new_fp(stderr,BIO_NOCLOSE);

	if (!load_config(bio_err, NULL))
		goto end;
	STDout=BIO_new_fp(stdout,BIO_NOCLOSE);
#ifdef OPENSSL_SYS_VMS
	{
	BIO *tmpbio = BIO_new(BIO_f_linebuffer());
	STDout = BIO_push(tmpbio, STDout);
	}
#endif

	informat=FORMAT_PEM;
	outformat=FORMAT_PEM;
	keyformat=FORMAT_PEM;
	CAformat=FORMAT_PEM;
	CAkeyformat=FORMAT_PEM;

	ctx=X509_STORE_new();
	if (ctx == NULL) goto end;
	X509_STORE_set_verify_cb_func(ctx,callb);

	argc--;
	argv++;
	num=0;
	while (argc >= 1)
		{
		if 	(strcmp(*argv,"-inform") == 0)				//OK
			{
			if (--argc < 1) goto bad;
			informat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-outform") == 0)			//OK
			{
			if (--argc < 1) goto bad;
			outformat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-config") == 0)
			{	
			if (--argc < 1) goto bad;
			template= *(++argv);
			}
		else if (strcmp(*argv,"-keyform") == 0)
			{
			if (--argc < 1) goto bad;
			keyformat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-AAform") == 0)
			{
			if (--argc < 1) goto bad;
			CAformat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-AAkeyform") == 0)
			{
			if (--argc < 1) goto bad;
			CAkeyformat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-days") == 0)
			{
			if (--argc < 1) goto bad;
			days=atoi(*(++argv));
			if (days == 0)
				{
				BIO_printf(STDout,"bad number of days\n");
				goto bad;
				}
			}
		else if (strcmp(*argv,"-HolderT") == 0)
			{
			if (--argc < 1) goto bad;
			holdert= *(++argv);
			}

		else if (strcmp(*argv,"-Attribute") == 0)
			{
			if (--argc < 1) goto bad;
			attributein= *(++argv);
			}
		else if (strcmp(*argv,"-passin") == 0)
			{
			if (--argc < 1) goto bad;
			passargin= *(++argv);
			}
		else if (strcmp(*argv,"-extfile") == 0)
			{
			if (--argc < 1) goto bad;
			extfile= *(++argv);
			}
		else if (strcmp(*argv,"-extensions") == 0)
			{
			if (--argc < 1) goto bad;
			extsect= *(++argv);
			}
		else if (strcmp(*argv,"-in") == 0)				//OK
			{
			if (--argc < 1) goto bad;
			infile= *(++argv);
			}
		else if (strcmp(*argv,"-out") == 0)				//OK
			{
			if (--argc < 1) goto bad;
			outfile= *(++argv);
			}
		else if (strcmp(*argv,"-User") == 0)				//OK
			{
			if (--argc < 1) goto bad;
			USERfile= *(++argv);
			USER_flag= ++num;
			}
		else if (strcmp(*argv,"-AA") == 0)				//OK
			{
			if (--argc < 1) goto bad;
			CAfile= *(++argv);
			CA_flag= ++num;
			
			}
		else if (strcmp(*argv,"-AAkey") == 0)			//OK
			{
			if (--argc < 1) goto bad;
			CAkeyfile= *(++argv);
			}
		else if (strcmp(*argv,"-AAserial") == 0)		//OK
			{
			if (--argc < 1) goto bad;
			CAserial= *(++argv);
			}
		else if (strcmp(*argv,"-set_serial") == 0)		//OK
			{
			if (--argc < 1) goto bad;
			if (!(sno = s2i_ASN1_INTEGER(NULL, *(++argv))))
				goto bad;
			}
		else if (strcmp(*argv,"-addtrust") == 0)
			{
			if (--argc < 1) goto bad;
			if (!(objtmp = OBJ_txt2obj(*(++argv), 0)))
				{
				BIO_printf(bio_err,"Invalid trust object value %s\n", *argv);
				goto bad;
				}
			if (!trust) trust = sk_ASN1_OBJECT_new_null();
			sk_ASN1_OBJECT_push(trust, objtmp);
			//trustout = 1;
			}
		else if (strcmp(*argv,"-addreject") == 0)
			{
			if (--argc < 1) goto bad;
			if (!(objtmp = OBJ_txt2obj(*(++argv), 0)))
				{
				BIO_printf(bio_err,"Invalid reject object value %s\n", *argv);
				goto bad;
				}
			if (!reject) reject = sk_ASN1_OBJECT_new_null();
			sk_ASN1_OBJECT_push(reject, objtmp);
			//trustout = 1;
			}
		else if (strcmp(*argv,"-setalias") == 0)
			{
			if (--argc < 1) goto bad;
			alias= *(++argv);
			//trustout = 1;
			}
		else if (strcmp(*argv,"-certopt") == 0)
			{
			if (--argc < 1) goto bad;
			if (!set_cert_ex(&certflag, *(++argv))) goto bad;
			}
		else if (strcmp(*argv,"-nameopt") == 0)
			{
			if (--argc < 1) goto bad;
			if (!set_name_ex(&nmflag, *(++argv))) goto bad;
			}
#ifndef OPENSSL_NO_ENGINE
		else if (strcmp(*argv,"-engine") == 0)
			{
			if (--argc < 1) goto bad;
			engine= *(++argv);
			}
#endif
		//else if (strcmp(*argv,"-C") == 0)
		//	C= ++num;
		//else if (strcmp(*argv,"-email") == 0)
		//	email= ++num;
		else if (strcmp(*argv,"-serial") == 0)			//OK
			serial= ++num;
		else if (strcmp(*argv,"-next_serial") == 0)		//OK
			next_serial= ++num;
		else if (strcmp(*argv,"-text") == 0)			
			text= ++num;
		else if (strcmp(*argv,"-hash") == 0)			
			hash= ++num;
		else if (strcmp(*argv,"-holder") == 0)			//OK
			holder= ++num;
		else if (strcmp(*argv,"-attributes") == 0)
			attributes= ++num;
		else if (strcmp(*argv,"-issuer") == 0)			//OK
			issuer= ++num;
		else if (strcmp(*argv,"-fingerprint") == 0)		//OK
			fingerprint= ++num;
		else if (strcmp(*argv,"-dates") == 0)			//OK
			{
			startdate= ++num;
			enddate= ++num;
			}
		else if (strcmp(*argv,"-purpose") == 0)
			pprint= ++num;
		else if (strcmp(*argv,"-startdate") == 0)		//OK
			startdate= ++num;
		else if (strcmp(*argv,"-enddate") == 0)			//OK
			enddate= ++num;
		else if (strcmp(*argv,"-checkend") == 0)
			{
			if (--argc < 1) goto bad;
			checkoffset=atoi(*(++argv));
			checkend=1;
			}
		else if (strcmp(*argv,"-noout") == 0)			//OK
			noout= ++num;
		/*else if (strcmp(*argv,"-trustout") == 0)
			trustout= 1;*/
		else if (strcmp(*argv,"-clrtrust") == 0)
			clrtrust= ++num;
		else if (strcmp(*argv,"-clrreject") == 0)
			clrreject= ++num;
		else if (strcmp(*argv,"-alias") == 0)
			aliasout= ++num;
		else if (strcmp(*argv,"-CAcreateserial") == 0)
			CA_createserial= ++num;
		else if (strcmp(*argv,"-clrext") == 0)
			clrext = 1;
#if 1 /* stay backwards-compatible with 0.9.5; this should go away soon */
		else if (strcmp(*argv,"-crlext") == 0)
			{
			BIO_printf(bio_err,"use -clrext instead of -crlext\n");
			clrext = 1;
			}
#endif
		else if ((md_alg=EVP_get_digestbyname(*argv + 1)))
			{
			/* ok */
			digest=md_alg;
			}
		else
			{
			BIO_printf(bio_err,"unknown option %s\n",*argv);
			badops=1;
			break;
			}
		argc--;
		argv++;
		}

	if (badops)
		{
bad:
		for (pp=x509_usage; (*pp != NULL); pp++)
			BIO_printf(bio_err,"%s",*pp);
		goto end;
		}

#ifndef OPENSSL_NO_ENGINE
        e = setup_engine(bio_err, engine, 0);
#endif

	
	if (template != NULL)
		{
		long errline = -1;

		//if( verbose )
			BIO_printf(bio_err,"Using configuration from %s\n",template);
		req_conf=NCONF_new(NULL);
		i=NCONF_load(req_conf,template,&errline);
		if (i == 0)
			{
			BIO_printf(bio_err,"error on line %ld of %s\n",errline,template);
			goto end;
			}
		}
	else
		{
		req_conf=config;
		//if( verbose )
			BIO_printf(bio_err,"Using configuration from %s\n",
			default_config_file);
		if (req_conf == NULL)
			{
			BIO_printf(bio_err,"Unable to load config info\n");
			}
		}

	if (need_rand)
		app_RAND_load_file(NULL, bio_err, 0);

	ERR_load_crypto_strings();

	if (!app_passwd(bio_err, passargin, NULL, &passin, NULL))
		{
		BIO_printf(bio_err, "Error getting password\n");
		goto end;
		}

	if (!X509_STORE_set_default_paths(ctx))
		{
		ERR_print_errors(bio_err);
		goto end;
		}

	if ((CAkeyfile == NULL) && (CA_flag) && (CAformat == FORMAT_PEM))
		{ CAkeyfile=CAfile; }
	else if ((CA_flag) && (CAkeyfile == NULL))
		{
		BIO_printf(bio_err,"need to specify a CAkey if using the CA command\n");
		goto end;
		}

	
	if (extfile)
		{
		long errorline = -1;
		X509V3_CTX ctx2;
		extconf = NCONF_new(NULL);
		if (!NCONF_load(extconf, extfile,&errorline))
			{
			if (errorline <= 0)
				BIO_printf(bio_err,"error loading the config file '%s'\n",extfile);
                	else
                        	BIO_printf(bio_err,"error on line %ld of config file '%s'\n",errorline,extfile);
			goto end;
			}
		if (!extsect)
			{
			extsect = NCONF_get_string(extconf, "default", "extensions");
			if (!extsect)
				{
				ERR_clear_error();
				extsect = "default";
				}
			}
		X509V3_set_ctx_test(&ctx2);
		X509V3_set_nconf(&ctx2, extconf);
		if (!X509V3_EXT_add_nconf(extconf, &ctx2, extsect, NULL))
			{
			BIO_printf(bio_err,"Error Loading extension section %s\n",extsect);
			ERR_print_errors(bio_err);
			goto end;
			}
		}

	xAT=X509AT_new(); 
	if (infile) {
			  xAT=load_ATcert(bio_err,infile,informat,NULL,e,"Certificate");
			  if (xAT== NULL)  goto end;
	}


	if (USER_flag) //Load user certificate
		{
		xuser=load_cert(bio_err,USERfile,CAformat,NULL,e,"USER Certificate");
		if (xuser == NULL) goto end;
	}
	else xuser=NULL;

	if (CA_flag) //Load CA certificate
		{
		xca=load_cert(bio_err,CAfile,CAformat,NULL,e,"AA Certificate");
		if (xca == NULL) goto end;
	}

	if (!noout || text || next_serial)
		{
		OBJ_create("2.99999.3","SET.ex3","SET x509v3 extension 3");

		out=BIO_new(BIO_s_file());
		if (out == NULL)
			{
			ERR_print_errors(bio_err);
			goto end;
			}
		if (outfile == NULL)
			{
			BIO_set_fp(out,stdout,BIO_NOCLOSE);
#ifdef OPENSSL_SYS_VMS
			{
			BIO *tmpbio = BIO_new(BIO_f_linebuffer());
			out = BIO_push(tmpbio, out);
			}
#endif
			}
		else
			{
			if (BIO_write_filename(out,outfile) <= 0)
				{
				perror(outfile);
				goto end;
				}
			}
		}

	if (alias) X509AT_alias_set1(xAT, (unsigned char *)alias, -1);

	if (clrtrust)  X509AT_trust_clear(xAT);
	if (clrreject) X509AT_reject_clear(xAT);

	if (trust)
		{
		for (i = 0; i < sk_ASN1_OBJECT_num(trust); i++)
			{
			objtmp = sk_ASN1_OBJECT_value(trust, i);
			X509AT_add1_trust_object(xAT, objtmp);
			}
		}

	if (reject)
		{
		for (i = 0; i < sk_ASN1_OBJECT_num(reject); i++)
			{
			objtmp = sk_ASN1_OBJECT_value(reject, i);
			X509AT_add1_reject_object(xAT, objtmp);
			}
		}

	if (num)
		{
		for (i=1; i<=num; i++)
			{
			if (issuer == i)											    //OK
				{
				BIO_printf(STDout, "Issuer: \n%s\n",  X509AT_get_issuer_info(xAT));
				}
			else if (holder == i)											//OK
				{
				BIO_printf(STDout, "Holder: \n%s\n",  X509AT_get_holder_info(xAT));
				}
			else if (attributes == i)										//OK
				{
				BIO_printf(STDout, "%s",  X509AT_get_att_info(xAT));
					
				}
			else if (serial == i)											//OK
				{
				BIO_printf(STDout,"serial=");
				i2a_ASN1_INTEGER(STDout,xAT->cert_info_at->serialNumber);
				BIO_printf(STDout,"\n");
				}
			else if (next_serial == i)										//OK
				{
				BIGNUM *bnser;
				ASN1_INTEGER *ser;
				ser = xAT->cert_info_at->serialNumber;
				bnser = ASN1_INTEGER_to_BN(ser, NULL);
				if (!bnser)
					goto end;
				if (!BN_add_word(bnser, 1))
					goto end;
				ser = BN_to_ASN1_INTEGER(bnser, NULL);
				if (!ser)
					goto end;
				BN_free(bnser);
				i2a_ASN1_INTEGER(out, ser);
				ASN1_INTEGER_free(ser);
				BIO_puts(out, "\n");
				}
			else if (aliasout == i)
				{
				unsigned char *alstr;
				alstr = X509AT_alias_get0(xAT, NULL);
				if (alstr) BIO_printf(STDout,"%s\n", alstr);
				else BIO_puts(STDout,"<No Alias>\n");
				}
			else if (hash == i)											//OK -- ???
				{
				BIO_printf(STDout,"%08lx\n",X509AT_issuer_hash(xAT));
					
				}
			else if (pprint == i)
				{
				X509_PURPOSE *ptmp;
				int j;
				BIO_printf(STDout, "Certificate purposes:\n");
				for (j = 0; j < X509_PURPOSE_get_count(); j++)
					{
					ptmp = X509_PURPOSE_get0(j);
					purpose_print(STDout, xAT, ptmp);
					}
				}
			else if (text == i)										//OK	
				{
				X509AT_print_ex(out,xAT,nmflag, certflag);
				}
			else if (startdate == i)								//OK 
				{
				BIO_puts(STDout,"notBefore=");
				ASN1_TIME_print(STDout,X509AT_get_notBefore(xAT));
				BIO_puts(STDout,"\n");
				}
			else if (enddate == i)									//OK 
				{
				BIO_puts(STDout,"notAfter=");
				ASN1_TIME_print(STDout,X509AT_get_notAfter(xAT));
				BIO_puts(STDout,"\n");
				}
			else if (fingerprint == i)								//OK 
				{
				int j;
				unsigned int n;
				unsigned char md[EVP_MAX_MD_SIZE];

				if (!X509AT_digestF(xAT,digest,md,&n))
					{
					BIO_printf(bio_err,"out of memory\n");
					goto end;
					}
				BIO_printf(STDout,"%s Fingerprint=",OBJ_nid2sn(EVP_MD_type(digest)));
				for (j=0; j<(int)n; j++)
					{
					BIO_printf(STDout,"%02X%c",md[j],
						(j+1 == (int)n)
						?'\n':':');
					}
				}
			else if (CA_flag == i)
				{
				BIO_printf(bio_err,"Getting AA Private Key \n");
				if (CAkeyfile != NULL)
					{
					CApkey=load_key(bio_err, CAkeyfile, CAkeyformat,0, passin, e, "AA Private Key");
					if (CApkey == NULL) goto end;
					}
#ifndef OPENSSL_NO_DSA
		                if (CApkey->type == EVP_PKEY_DSA)
		                        digest=EVP_dss1();
#endif
				
				//assert(need_rand);
				if (!x509_certify(ctx,CAfile,digest,xAT,xca,CApkey, CAserial,CA_createserial,days, clrext,extconf, extsect, sno,xuser,attributein))	// CREA EL CERTIFICADO NUEVO
					goto end;
				}
			

			}
		}


	if (checkend)												//OK pero hay que probarlo
		{
		time_t tnow=time(NULL);

		if (ASN1_UTCTIME_cmp_time_t(X509AT_get_notAfter(xAT), tnow+checkoffset) == -1)
			{
			BIO_printf(out,"Certificate will expire\n");
			ret=1;
			}
		else
			{
			BIO_printf(out,"Certificate will not expire\n");
			ret=0;
			}
		goto end;
		}


	if (noout)
		{
		ret=0;
		goto end;
		}

			

	if 	(outformat == FORMAT_ASN1)								//Ok
		i=i2d_X509AT_bio(out,xAT);
	else if (outformat == FORMAT_PEM)
		{
		   i=PEM_write_bio_X509AT(out,xAT);					//OK
		}
	else	{
		BIO_printf(bio_err,"bad output format specified for outfile\n");
		goto end;
		}


	if (!i)
		{
		BIO_printf(bio_err,"unable to write certificate\n");
		ERR_print_errors(bio_err);
		goto end;
		}
	ret=0;
end:
	if (need_rand)
		app_RAND_write_file(NULL, bio_err);
	OBJ_cleanup();
	NCONF_free(extconf);
	BIO_free_all(out);
	BIO_free_all(STDout);
	X509_STORE_free(ctx);
	X509_free(x);
	X509_free(xca);
	EVP_PKEY_free(Upkey);
	EVP_PKEY_free(CApkey);
	X509_REQ_free(rq);
	ASN1_INTEGER_free(sno);
	sk_ASN1_OBJECT_pop_free(trust, ASN1_OBJECT_free);
	sk_ASN1_OBJECT_pop_free(reject, ASN1_OBJECT_free);
	if (passin) OPENSSL_free(passin);
	apps_shutdown();
	OPENSSL_EXIT(ret);
	}

static ASN1_INTEGER *x509_load_serial(char *CAfile, char *serialfile, int create)
	{
	char *buf = NULL, *p;
	ASN1_INTEGER *bs = NULL;
	BIGNUM *serial = NULL;
	size_t len;

	len = ((serialfile == NULL)
		?(strlen(CAfile)+strlen(POSTFIX)+1)
		:(strlen(serialfile)))+1;
	buf=OPENSSL_malloc(len);
	if (buf == NULL) { BIO_printf(bio_err,"out of mem\n"); goto end; }
	if (serialfile == NULL)
		{
		BUF_strlcpy(buf,CAfile,len);
		for (p=buf; *p; p++)
			if (*p == '.')
				{
				*p='\0';
				break;
				}
		BUF_strlcat(buf,POSTFIX,len);
		}
	else
		BUF_strlcpy(buf,serialfile,len);

	serial = load_serial(buf, create, NULL);
	if (serial == NULL) goto end;

	if (!BN_add_word(serial,1))
		{ BIO_printf(bio_err,"add_word failure\n"); goto end; }

	if (!save_serial(buf, NULL, serial, &bs)) goto end;

 end:
	if (buf) OPENSSL_free(buf);
	BN_free(serial);
	return bs;
	}

/******************* MAIN FUNCTION TO CREATE CERTIFY ***********************/
static int x509_certify(X509_STORE *ctx, char *CAfile, const EVP_MD *digest,
	     X509AT *x, X509 *xca, EVP_PKEY *pkey, char *serialfile, int create,
	     int days, int clrext, CONF *conf, char *section, ASN1_INTEGER *sno,X509 *xuser,char *attributein)
	{
	
	ASN1_INTEGER *bs=NULL;
	int ret=0;
	EVP_PKEY *upkey;
	EVP_PKEY *publicKeyUser;
	time_t t;
	ASN1_TIME *s=NULL;
	int numAtt=0;

	X509_NAME *nmuser;
	GENERAL_NAMES * gensuser = NULL;
	GENERAL_NAME *genuser;

	X509_NAME *nm;
	GENERAL_NAMES * gens = NULL;
	GENERAL_NAME *gen;

	X509_ALGOR *  alg_id; 
	ASN1_BIT_STRING *hash;
	ASN1_ENUMERATED *e;
	unsigned char md[MD5_DIGEST_LENGTH];

	if (xuser!=NULL) publicKeyUser = X509_get_pubkey(xuser);

	upkey = X509_get_pubkey(xca);
	EVP_PKEY_copy_parameters(upkey,pkey);
	EVP_PKEY_free(upkey);


	if (sno) bs = sno;
	else if (!(bs = x509_load_serial(CAfile, serialfile, create)))
	goto end;


	if (!X509_check_private_key(xca,pkey))
		{
		BIO_printf(bio_err,"AA certificate and AA private key do not match\n");
		goto end;
		}

	/// SUBJECT AA-------------------------------------------
	nm=X509_get_subject_name(xca);

	gen = GENERAL_NAME_new();
	if (!X509_NAME_set(&gen->d.directoryName, nm))
		{
		GENERAL_NAME_free(gen);
		}
	gen->type = GEN_DIRNAME;

	if(!(gens = sk_GENERAL_NAME_new_null()) || !sk_GENERAL_NAME_push(gens, GENERAL_NAME_dup(gen))) {
		X509V3err(X509V3_F_V2I_AUTHORITY_KEYID,ERR_R_MALLOC_FAILURE);
		goto end;

	}
	// End SUBJECT AA -------------------------------------------

	/// HOLDER-------------------------------------------
	if (xuser!=NULL){
		nmuser=X509_get_subject_name(xuser);

		genuser = GENERAL_NAME_new();
		if (!X509_NAME_set(&genuser->d.directoryName, nmuser))
			{
			GENERAL_NAME_free(genuser);
			}
		genuser->type = GEN_DIRNAME;

		if(!(gensuser = sk_GENERAL_NAME_new_null()) || !sk_GENERAL_NAME_push(gensuser, GENERAL_NAME_dup(genuser))) {
			X509V3err(X509V3_F_V2I_AUTHORITY_KEYID,ERR_R_MALLOC_FAILURE);
			goto end;

		}
    }
	else gensuser=gens;
	/// END HOLDER-------------------------------------------

	//x->cert_info_at = (X509AT_CINF *) calloc (1,sizeof(X509AT_CINF));

	x->cert_info_at->issuer = (X509AT_ATTCERTISSUER *) calloc (1,sizeof(X509AT_ATTCERTISSUER));
	x->cert_info_at->issuer->type=1;
	x->cert_info_at->issuer->value.v2Form = (X509AT_V2FORM *) calloc (1,sizeof(X509AT_V2FORM));
	x->cert_info_at->issuer->value.v2Form->issuerName=gens;
	x->cert_info_at->issuer->value.v2Form->baseCertificateID=NULL;
	x->cert_info_at->issuer->value.v2Form->objectDigestInfo =NULL;

	X509AT_set_version(x,1);
	//////////////////////////////////////////////////////////
	// HOLDER
	
	//holder = 0 entityName; 1 baseCertificateID; 2 objectDigestInfo PUBLICKEYCERT

	

	x->cert_info_at->holder = (X509AT_HOLDER *)  calloc (1,sizeof(X509AT_HOLDER));
	if ((holdert==NULL) || ((strcmp(holdert,"1")) && (strcmp(holdert,"2")))) x->cert_info_at->holder->entityName=gensuser; 
	else x->cert_info_at->holder->entityName=NULL; 
	
	if (xuser!=NULL && holdert!=NULL && (strcmp(holdert,"1") == 0)) {
		x->cert_info_at->holder->baseCertificateID= (X509AT_ISSUER_SERIAL *)  calloc (1,sizeof(X509AT_ISSUER_SERIAL));
		x->cert_info_at->holder->baseCertificateID->issuer=gensuser;
		x->cert_info_at->holder->baseCertificateID->serial=X509_get_serialNumber(xuser);		
	}
	else x->cert_info_at->holder->baseCertificateID= NULL;

	if (xuser!=NULL && holdert!=NULL && (strcmp(holdert,"2") == 0)) {
		x->cert_info_at->holder->objectDigestInfo= (X509AT_OBJECTDIGESTINFO *) calloc (1,sizeof(X509AT_OBJECTDIGESTINFO));
		e = ASN1_ENUMERATED_new();

		ASN1_ENUMERATED_set(e, OBJECTDIGESTINFO_PUBLICKEYCERT); //TODO OBJECTDIGESTINFO_PUBLICKEY 0
	

		x->cert_info_at->holder->objectDigestInfo->digestedObjectType= e;
		x->cert_info_at->holder->objectDigestInfo->otherObjectTypeID=NULL;
		
		alg_id =X509_ALGOR_new();
		alg_id->algorithm=ASN1_OBJECT_new();
		alg_id->algorithm = OBJ_nid2obj(EVP_MD_type(EVP_md5()));
		x->cert_info_at->holder->objectDigestInfo->digestAlgorithm=alg_id;

		EVP_Digest(xuser,(unsigned long)strlen((char *)xuser),md,NULL,EVP_md5(), NULL);
		
		hash=ASN1_BIT_STRING_new();
		ASN1_BIT_STRING_set(hash,md,strlen(md));

		x->cert_info_at->holder->objectDigestInfo->objectDigest=hash;
	}
	else x->cert_info_at->holder->objectDigestInfo= NULL;


	//////////////////////////////////////////////////////////

	if (!X509AT_set_serialNumber(x,bs)) goto end;

	
	time(&t);
	s=ASN1_GENERALIZEDTIME_new();
	s->type=V_ASN1_GENERALIZEDTIME;
	ASN1_GENERALIZEDTIME_set(s, t);	
	X509AT_set_notBefore(x, s);
	
	t+=(long)60*60*24*days;
	ASN1_GENERALIZEDTIME_set(s, t);
	X509AT_set_notAfter (x,s);

	//////////////////////////////////////////////////////////
	// ATRUBUTOS
	

	x->cert_info_at->attributes = readAttributes(attributein);
	
	//////////////////////////////////////////////////////

	
    if (!X509AT_sign(x,pkey,digest)) goto end;
	
		
	if (!sno) ASN1_INTEGER_free(bs);
		
	ret=1;
end:
	
	if (!ret)ERR_print_errors(bio_err);
	if (!sno) ASN1_INTEGER_free(bs);
	
	return ret;
	}

static int MS_CALLBACK callb(int ok, X509_STORE_CTX *ctx)
	{
	int err;
	X509 *err_cert;

	/* it is ok to use a self signed certificate
	 * This case will catch both the initial ok == 0 and the
	 * final ok == 1 calls to this function */
	err=X509_STORE_CTX_get_error(ctx);
	if (err == X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT)
		return 1;

	/* BAD we should have gotten an error.  Normally if everything
	 * worked X509_STORE_CTX_get_error(ctx) will still be set to
	 * DEPTH_ZERO_SELF_.... */
	if (ok)
		{
		BIO_printf(bio_err,"error with certificate to be certified - should be self signed\n");
		return 0;
		}
	else
		{
		err_cert=X509_STORE_CTX_get_current_cert(ctx);
		print_name(bio_err, NULL, X509_get_subject_name(err_cert),0);
		BIO_printf(bio_err,"error with certificate - error %d at depth %d\n%s\n",
			err,X509_STORE_CTX_get_error_depth(ctx),
			X509_verify_cert_error_string(err));
		return 1;
		}
	}


static int purpose_print(BIO *bio, X509AT *cert, X509_PURPOSE *pt)
{
	int id, i, idret;
	char *pname;
	id = X509_PURPOSE_get_id(pt);
	pname = X509_PURPOSE_get0_name(pt);
	for (i = 0; i < 2; i++)
		{
		idret = X509AT_check_purpose(cert, id, i);
		BIO_printf(bio, "%s%s : ", pname, i ? " CA" : ""); 
		if (idret == 1) BIO_printf(bio, "Yes\n");
		else if (idret == 0) BIO_printf(bio, "No\n");
		else BIO_printf(bio, "Yes (WARNING code=%d)\n", idret);
		}
	return 1;
}

//Funcion para coger el certificado de atributos

static X509AT *load_ATcert(BIO *err, const char *file, int format,
							const char *pass, ENGINE *e, const char *cert_descrip)
	{
	X509AT *x=NULL;
	BIO *cert;

	if ((cert=BIO_new(BIO_s_file())) == NULL)
		{
		ERR_print_errors(err);
		goto end;
		}

	if (file == NULL)
		{
		setvbuf(stdin, NULL, _IONBF, 0);
		BIO_set_fp(cert,stdin,BIO_NOCLOSE);
		}
	else
		{
		if (BIO_read_filename(cert,file) <= 0)
			{
			BIO_printf(err, "Error opening %s %s\n",cert_descrip, file);
			ERR_print_errors(err);
			goto end;
			}
		}
	
	
	if 	(format == FORMAT_ASN1)
		x= d2i_X509AT_bio(cert,NULL);
	else if (format == FORMAT_PEM)
		x=PEM_read_bio_X509AT(cert,NULL,(pem_password_cb *)password_callback, NULL); //AUX ???
		//PEM_read_bio_X509_AUX
	else	{
		BIO_printf(err,"bad input format specified for %s\n",cert_descrip);
		goto end;
		}
end:
	if (x == NULL)
		{
		BIO_printf(err,"unable to load certificate\n");
		ERR_print_errors(err);
		}
	if (cert != NULL) BIO_free(cert);
	
	return(x);
}





STACK_OF(X509AT_ATTRIBUTE) * readAttributes(char *file){

	char attribute[200];
	char name[200]; char value[200];
	int i,j;
	BIO *in;
	int readbytes;
	int comment,exit;
	int lineas;
	int atributos;
	STACK_OF(X509AT_ATTRIBUTE) *ats;
	X509AT_ATTRIBUTE *at;
				ASN1_TYPE *ttmp;

	if (file==NULL) in = BIO_new_file("Attribute.txt", "r"); 
	else in = BIO_new_file(file, "r");
    if(!in) BIO_printf(bio_err,"Error attribute file\n");

	i=0,j=0;
	comment=0,exit=0;
	lineas=0,atributos=0;

	
	ats=sk_X509AT_ATTRIBUTE_new_null();


	readbytes=BIO_gets(in,attribute, 200);
	
	while (readbytes!=0){
	
			lineas++;

			i=0,j=0;
			comment=0,exit=0;
		
			while (attribute[i]!='\0' && !exit) {
				if (attribute[i]=='#' || attribute[i]=='\n' || attribute[i]=='\r') { comment=1; exit=1;}
				else if (attribute[i]!=' ') exit=1;
				i++;
			}

			if (attribute[i]=='\0') comment=1; // Spaces
			if (!comment)  {

				i=0,j=0;
				while (attribute[i]!='\0' && attribute[i]!='=') { 
					
					if (attribute[i]!=' '){
						name[j]=attribute[i];
						j++;
					}
					i++;	
				}
				name[j]='\0';

				j=0;
				while (attribute[i]!='\0' && attribute[i]!='\n' && attribute[i]!='\r') { 
				
					if (attribute[i]!='=' && attribute[i]!=' '){
						value[j]=attribute[i];
						j++;
					}
					i++;	
				}
				value[j]='\0';

				//printf("Atribute: %s-\n",attribute);
				//printf("(%d)Name:%s-Value:%s-\n",lineas,name,value);
				   
				at=X509AT_ATTRIBUTE_new();
				at->object=OBJ_txt2obj(name, 1);
				at->single=0; //Siempre se utilizara 0: SET
				at->value.set = sk_ASN1_TYPE_new_null();

				
				ttmp = ASN1_TYPE_new();
				ttmp->value.asn1_string = ASN1_STRING_new();
				ASN1_STRING_set(ttmp->value.asn1_string,value,strlen(value)+1);
				ttmp->type = V_ASN1_PRINTABLESTRING;

				sk_ASN1_TYPE_push(at->value.set,ttmp);
				sk_X509AT_ATTRIBUTE_insert(ats, at,sk_X509AT_ATTRIBUTE_num(ats));

				atributos++;
			}
			//else printf("(%d)Es un comentario\n",lineas);
	
		readbytes=BIO_gets(in,attribute, 200);
	}
	
 return ats;
}	
